import { StyleSheet } from "react-native";
import dpr from "../../../../Utilities/CustomStyleAttribute/dpr";

const DeliveryOptionStyle = StyleSheet.create({
    container: {
        backgroundColor: "#FFFFFF",
        marginHorizontal: dpr(20),
        paddingVertical: dpr(15),
    },
    subCont: {
        backgroundColor: "#F3F3F3",
        padding: dpr(18),
        borderRadius: dpr(6),
    },
    title: {
        flexDirection: "row",
        justifyContent: "space-between",
        marginBottom: dpr(14),
    },
    textTitle: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(18),
        color: "#2C2C2C",
        textAlign: 'left'
    },
    address: {
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(13),
        lineHeight: dpr(20),
        color: "#898989",
        textAlign: 'left'
    },
    delivery: {
        flexDirection: "row",
        gap: dpr(10),
    },
    mt18: (type) => ({
        marginTop: type == "External/Affiliate Product" ? 0 : dpr(18),
    }),
    deliveryText: {
        width: dpr(140),
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(14),
        color: "#2C2C2C",
        textAlign: 'left'
    },
    deliveryInfo: {
        width: dpr(140),
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(14),
        color: "#2C2C2C",
        textAlign: 'left'
    },
    grayColor: {
        color: "#898989",
    },
    mt5: {
        marginTop: dpr(5),
    },
});

export default DeliveryOptionStyle;
